<?php
/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/
?>
<div id="box">
	<h3>Videos</h3>
	<?php echo $session->flash(); ?>
	<table width="100%">
		<thead>
			<tr>
				<th width="40px"><a href="#">ID</a></th>
				<th><a href="#">Video Title</a></th>
				<th><a href="#">Video ID</a></th>
				<th><a href="#">Source</a></th>
				<th><a href="#">Width / Height</a></th>
				<th width="60px"><a href="#">Action</a></th>
			</tr>
		</thead>
		<tbody>
		<?php 
			foreach($videos as $video) {
		?>	
			<tr>
				<td class="a-center"><?php echo $video['Video']['id']?></td>
				<td class="a-center"><a href="#"><?php echo substr($video['Video']['name'],0,30);?></a></td>								
				<td class="a-center"><?php echo $video['Video']['video_id'];?></td>
				<td class="a-center"><?php echo $video['Video']['source'];?></td>
				<td class="a-center"><?php echo $video['Video']['width'];?> /  <?php echo $video['Video']['height'];?></td>				
				<td class="a-center">
					<?php echo $html->link(
								$this->Html->image('icons/page_white_edit.png', array('alt' => 'edit video')), array(
										'controller' => 'videos',
										'action' => 'edit',
										'id' => $video['Video']['id'],
										'admin' => 'admin'
									),array('escape' => false)
					);?>					
					<?php echo $html->link(
								$this->Html->image('icons/page_white_delete.png', array('alt' => 'delete video')), 
								array(
										'controller' => 'videos',
										'action' => 'delete',
										'id' => $video['Video']['id'],
										'admin' => 'admin'
									),
								array('escape' => false),	
								'Are you sure you wish to delete?'
					);?>
				</td>
			</tr>
		<?php
			}
		?>	
		</tbody>
	</table>
	<div id="pager">
		<!-- Shows the page numbers -->	
		<?php echo $this->Paginator->prev(__('previous',true), null, null, array('class' => 'disabled')); ?>
		<?php echo $this->Paginator->numbers(); ?>
		<!-- Shows the next and previous links -->
		<?php echo $this->Paginator->next(__('next',true), null, null, array('class' => 'disabled')); ?>
		<!-- prints X of Y, where X is current page and Y is number of pages -->
		( Pages <?php echo $this->Paginator->counter(); ?> )
	</div>
	
	<?php 
	echo $html->link(
		"Add Video", array(
			'controller' => 'videos',
			'action' => 'add',				
			'admin' => 'admin'
		)
	);
	?>
</div>